/************************************************************************
 *
 * \file: DeviceMonitor.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto - Demo application
 *
 * \author: J. Harder / ADITG/SW1 / jharder@de.adit-jv.com
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef AAUTOT_DEVICEMONITOR_H
#define AAUTOT_DEVICEMONITOR_H

#include <atomic>
#include <list>
#include <string>
#include <pthread_adit.h>


// FeatureDiscovery headers
#include <uspi/FeatureDiscoveryTypes.h>
#include <uspi/FeatureDiscovery.h>
#include <uspi/IFeatureDiscovery.h>

// DeviceDetector headers
// included to set the device mask to watch for (enum DD_EVENT_MASK)
#include <uspi/deviceDetector.h>
// necessary to retrieve device attributes like vendorId, productId, serial
#include <uspi/deviceManagement.h>


#include "utils/IStoppable.h"
#include "utils/UsbDeviceId.h"

#include <condition_variable>
#include <mutex>

namespace adit { namespace aauto {

// handles switching, transport and session creation
class DeviceMonitor : public IStoppable, adit::uspi::IFeatureDiscoveryCb
{
public:
    DeviceMonitor();
    virtual ~DeviceMonitor();

    bool start();
    void stop();

    void waitForExit();

    // to be implemented by user
    virtual void onDeviceFound(std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice) = 0;
    virtual void onDeviceSwitched(std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice) = 0;
    // this may be a normal or a switched device
    virtual void onDeviceLost(std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice) = 0;
    virtual void onDeviceChanged(std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice) = 0;
    virtual void onDeviceError(adit::uspi::DiscoveryError inErrorCode) = 0;

    // IStoppable implementation
    void requestStop();
    
    // location to test the sensor source test
    void setLocation(std::string inLocation) { testLocation = inLocation; }
    std::string getLocation() { return testLocation; }
    bool getRunningStatus(){return running;}

    void resetDevice(/*const*/ std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice, bool isAutoTest);

protected:
    // some helpers
    void resetDevice(/*const*/ std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice);
    void waitForDeviceReset(std::shared_ptr<adit::uspi::DiscoveredDeviceUsb> inUsbDevice);

private:
    /* callbacks received from FeatureDiscovery */
    adit::uspi::DiscoveryError foundCb(std::shared_ptr<adit::uspi::DiscoveredDevice> inDevice);
    adit::uspi::DiscoveryError lostCb(std::shared_ptr<adit::uspi::DiscoveredDevice> inDevice);
    adit::uspi::DiscoveryError switchedCb(std::shared_ptr<adit::uspi::DiscoveredDevice> inDevice);
    adit::uspi::DiscoveryError changedCb(std::shared_ptr<adit::uspi::DiscoveredDevice> inDevice);
    adit::uspi::DiscoveryError errorCb(adit::uspi::DiscoveryError inErrorCode);

    /* FeatureDiscovery */
    adit::uspi::FeatureDiscovery* discoverer;
    bool running;

    std::atomic_flag resetFlag;
    pthread_mutex_t resetMutex;
    std::list<std::shared_ptr<adit::uspi::DiscoveredDeviceUsb>> resetInfos;
    std::string testLocation;

    std::condition_variable mCondVarWaitForExit;
    std::mutex mMutex;
};

std::string to_string(adit::uspi::DeviceInfo& inVal);


} } /* namespace adit { namespace aauto */
#endif /* AAUTOT_DEVICEMONITOR_H */
